/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.lpar;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspVioSmcaConfig;
import com.ibm.hsc.fsp.cmdhelpers.VioSlotState;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.lpar.OmLparMgr;
import com.ibm.hsc.objmgr.lpar.OmLparVscsiUpdater;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50Define;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;

public class OmLparVsmcaUpdater {
    private OmLparMgr mLparMgr;
    private OmCecMgr mCecMgr;
    private RObject mLparObj;
    private RObjectId mLparOid;
    private int updateFlag = 0;
    private FspCmdHelper mCmdHelper;
    private FSPCmdMgr mCmdMgr;

    public OmLparVsmcaUpdater(OmLparMgr omLparMgr) {
        this.mLparMgr = omLparMgr;
        this.mLparObj = this.mLparMgr.getObject();
        this.mLparOid = this.mLparMgr.getObjectId();
        this.mCecMgr = this.mLparMgr.getCecMgr();
        this.mCmdHelper = this.mCecMgr.getCmdHelper();
        this.mCmdMgr = this.mCecMgr.getCmdMgr();
    }

    public void update(Hashtable hashtable) throws RException, PIHscServerException, PIHscCmdMgrException {
        Object object;
        RObject rObject;
        Object object2;
        Object object3;
        Enumeration<Object> enumeration;
        Vector vector = this.mLparObj.associators(R50Define.AID_IBMHSC_LparVirtualSMCA);
        if (vector != null) {
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object3 = (RObject)enumeration.nextElement();
                object2 = (String)((RObject)object3).getProperty("Name");
                rObject = new UnsignedInt16((String)object2);
                object = (VioSlotState)hashtable.get(rObject);
                if (object == null) {
                    this.deleteVsmca((RObject)object3);
                    continue;
                }
                FspVioSmcaConfig fspVioSmcaConfig = this.mCmdHelper.getSharedMemoryClusterIO(new UnsignedInt16(this.mLparMgr.getLparIndex()), (UnsignedInt16)rObject);
                if (this.updateVsmcaInstance((RObject)object3, fspVioSmcaConfig, (VioSlotState)object)) {
                    // empty if block
                }
                hashtable.remove(rObject);
            }
        }
        enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            object3 = (VioSlotState)enumeration.nextElement();
            object2 = ((VioSlotState)object3).slotNumber;
            rObject = OmLparVscsiUpdater.getSameSlotNum(object2, this.mLparMgr.getLparName());
            if (rObject != null) {
                OmLparVscsiUpdater.deleteVslotWithDiffType(rObject, this.mLparMgr);
                continue;
            }
            object = this.mCmdHelper.getSharedMemoryClusterIO(new UnsignedInt16(this.mLparMgr.getLparIndex()), ((VioSlotState)object3).slotNumber);
            this.createNewVsmcaInstance((FspVioSmcaConfig)object, (VioSlotState)object3);
        }
        System.out.println("client table = " + this.mCecMgr.getClientAdaptersTable());
        System.out.println("server table = " + this.mCecMgr.getServerAdaptersTable());
        System.out.println("incompatible client table = " + this.mCecMgr.getIncompatibleClients());
    }

    private void createNewVsmcaInstance(FspVioSmcaConfig fspVioSmcaConfig, VioSlotState vioSlotState) throws RException {
        RObjectId rObjectId = new RObjectId(1, R50Define.CID_IBMHSC_VirtualSMCA);
        rObjectId.setKeyValue(0, "IBMHSC_VirtualSMCA");
        rObjectId.setKeyValue(1, vioSlotState.slotNumber.toString());
        rObjectId.setKeyValue(2, "IBMHSC_Partition");
        rObjectId.setKeyValue(3, this.mLparMgr.getLparName());
        RObject rObject = new RObject(rObjectId);
        rObject.addInstance();
        rObject.addAssociation(R50Define.AID_IBMHSC_LparVirtualSMCA, this.mLparOid);
        System.out.println("lpar id = " + this.mLparMgr.getLparName() + "virtual slot = " + vioSlotState.slotNumber + " versmcaConfig = " + fspVioSmcaConfig);
        this.updateVsmcaInstance(rObject, fspVioSmcaConfig, vioSlotState);
    }

    private boolean updateVsmcaInstance(RObject rObject, FspVioSmcaConfig fspVioSmcaConfig, VioSlotState vioSlotState) throws RException {
        return this.updateVsmcaProperties(rObject, fspVioSmcaConfig, vioSlotState);
    }

    private boolean updateVsmcaProperties(RObject rObject, FspVioSmcaConfig fspVioSmcaConfig, VioSlotState vioSlotState) throws RException {
        boolean bl = false;
        if (rObject.setProperty("Required", (Object)new Boolean(fspVioSmcaConfig.isRequired()))) {
            bl = true;
        }
        if (rObject.setProperty("DrcIndex", (Object)fspVioSmcaConfig.getDrcIndex())) {
            bl = true;
        }
        if (rObject.setProperty("DrcName", (Object)fspVioSmcaConfig.getDrcName())) {
            bl = true;
        }
        if (rObject.setProperty("RemoteLparID", (Object)fspVioSmcaConfig.getRemoteLparID())) {
            bl = true;
        }
        if (rObject.setProperty("RemoteSlotID", (Object)fspVioSmcaConfig.getRemoteSlotID())) {
            bl = true;
        }
        if (rObject.setProperty("HubDrcIndex", (Object)fspVioSmcaConfig.getHubDrcIndex())) {
            bl = true;
        }
        if (rObject.setProperty("RioBusNum", (Object)fspVioSmcaConfig.getIOBusID())) {
            bl = true;
        }
        if (rObject.setProperty("CurLockOwnerClass", (Object)vioSlotState.curLockOwnerClass)) {
            bl = true;
        }
        if (rObject.setProperty("CurLockOwnerId", (Object)vioSlotState.currentSlotLockOwner)) {
            bl = true;
        }
        if (rObject.setProperty("PendLockOwnerClass", (Object)vioSlotState.pendLockOwnerClass)) {
            bl = true;
        }
        if (rObject.setProperty("PendLockOwnerId", (Object)vioSlotState.pendingSlotLockOwner)) {
            bl = true;
        }
        return bl;
    }

    public void deleteVsmca(RObject rObject) throws RException {
        if (rObject != null) {
            rObject.deleteInstance();
        }
    }
}

